using System;
using System.Data;
using System.Windows.Forms;
//
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;
//
namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Summary description for OutgoingShipment.
	/// </summary>
	public class ProcessOutgoingShipment
	{
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="thisUser"></param>
        /// <param name="parent"></param>
        /// <param name="useNew"></param>
        public ProcessOutgoingShipment(VbecsUser thisUser, 
            System.Windows.Forms.Form parent, 
            bool useNew)
        {
            try
            {
                if ( thisUser.IsAuthorized( Common.UserRoleType.Technologist ) )
                {
                    DataTable dtInvoices = BOL.OutgoingShipmentCollection.GetRecentInvoicesForDivision();
                    DlgShipmentOut shipmentOut = new DlgShipmentOut(useNew, dtInvoices);
                    //
           			shipmentOut.MdiParent = parent;
					shipmentOut.Show();
                }
                else
                {
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges(
						"perform this function"));
				}
            }
            catch (Exception ex)
            {
                ExceptionManagement.ExceptionManager.Publish(ex);
				GuiMessenger.ShowMessageBox(parent, Common.StrRes.SysErrMsg.Common.Dynamic("System error. Please try again later"));
            }
            //
		}
	}
}
